#define NONORMAL
#include "InventorBasicEffectDx9.fxh"

struct VSPosCol
{
	float3 Pos			: Position;
	float4 Col			: Color;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosCol( VSPosCol Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	Out.ColorD = Input.Col;

#ifdef DIFFUSE_TEXTURE	
	//automatic texture coordinate generation
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		Out.ColorSAndFogFactor.w = CalcFogFactor(ViewPos.z);
	}
	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosCol( PSInput Input ) : COLOR0
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	if(Input.ColorD.a < g_Misc.w)
		discard;
	float4 Color=(float4)0;
	Color.xyz = saturate(Input.ColorD.xyz + Input.ColorSAndFogFactor.xyz);
	Color.a = Input.ColorD.a;

	if(g_fogEnabled)
	{
		float FogFactor = Input.ColorSAndFogFactor.w;
		return FogFactor * Color + (1.0 - FogFactor) * g_fogColor;
	}
	else
		return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique PosCol
{
    pass P0
    {   
	VertexShader = compile vs_2_0 VS_PosCol();
       	PixelShader = compile ps_2_0 PS_PosCol();
    }
}